/*
 * Decompiled with CFR 0.152.
 */
package com.jamieswhiteshirt.reachentityattributes;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.ParametersAreNonnullByDefault;
import net.fabricmc.api.ModInitializer;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1324;
import net.minecraft.class_1329;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_7923;

@ParametersAreNonnullByDefault
public final class ReachEntityAttributes
implements ModInitializer {
    public static final String MOD_ID = "reach-entity-attributes";
    public static final class_1320 REACH = ReachEntityAttributes.make("reach", 0.0, -1024.0, 1024.0);
    public static final class_1320 ATTACK_RANGE = ReachEntityAttributes.make("attack_range", 0.0, -1024.0, 1024.0);

    public static double getReachDistance(class_1309 entity, double baseReachDistance) {
        class_1324 reachDistance = entity.method_5996(REACH);
        return reachDistance != null ? baseReachDistance + reachDistance.method_6194() : baseReachDistance;
    }

    public static double getSquaredReachDistance(class_1309 entity, double sqBaseReachDistance) {
        double reachDistance = ReachEntityAttributes.getReachDistance(entity, Math.sqrt(sqBaseReachDistance));
        return reachDistance * reachDistance;
    }

    public static double getAttackRange(class_1309 entity, double baseAttackRange) {
        class_1324 attackRange = entity.method_5996(ATTACK_RANGE);
        return attackRange != null ? baseAttackRange + attackRange.method_6194() : baseAttackRange;
    }

    public static double getSquaredAttackRange(class_1309 entity, double sqBaseAttackRange) {
        double attackRange = ReachEntityAttributes.getAttackRange(entity, Math.sqrt(sqBaseAttackRange));
        return attackRange * attackRange;
    }

    public static List<class_1657> getPlayersWithinReach(class_1937 world, int x, int y, int z, double baseReachDistance) {
        return ReachEntityAttributes.getPlayersWithinReach(player -> true, world, x, y, z, baseReachDistance);
    }

    public static List<class_1657> getPlayersWithinReach(Predicate<class_1657> viewerPredicate, class_1937 world, int x, int y, int z, double baseReachDistance) {
        ArrayList<class_1657> playersWithinReach = new ArrayList<class_1657>(0);
        for (class_1657 player : world.method_18456()) {
            double dz;
            double dy;
            if (!viewerPredicate.test(player)) continue;
            double reach = ReachEntityAttributes.getReachDistance((class_1309)player, baseReachDistance);
            double dx = (double)x + 0.5 - player.method_23317();
            if (!(dx * dx + (dy = (double)y + 0.5 - player.method_23320()) * dy + (dz = (double)z + 0.5 - player.method_23321()) * dz <= reach * reach)) continue;
            playersWithinReach.add(player);
        }
        return playersWithinReach;
    }

    public static boolean isWithinAttackRange(class_1657 player, class_1297 entity) {
        return player.method_5858(entity) <= ReachEntityAttributes.getSquaredAttackRange((class_1309)player, 64.0);
    }

    private static class_1320 make(String name, double base, double min, double max) {
        return new class_1329("attribute.name.generic.reach-entity-attributes." + name, base, min, max).method_26829(true);
    }

    public void onInitialize() {
        class_2378.method_10230((class_2378)class_7923.field_41190, (class_2960)new class_2960(MOD_ID, "reach"), (Object)REACH);
        class_2378.method_10230((class_2378)class_7923.field_41190, (class_2960)new class_2960(MOD_ID, "attack_range"), (Object)ATTACK_RANGE);
    }
}

